﻿using System;

namespace Microscopic_Traffic_Simulator___Model.GeneralParameters
{
    /// <summary>
    /// Class containing parameters of transition function.
    /// </summary>
    [Serializable]
    public class TransitionFunctionParameters
    {
        /// <summary>
        /// Low speed deceleration probability.
        /// </summary>
        public double P5_LowSpeedDecProbability { get; set; }

        /// <summary>
        /// Threshold speed for the p5 and p8.
        /// </summary>
        public int P6_DecProbabilitySpeedBound { get; set; }

        /// <summary>
        /// Acceleration probability.
        /// </summary>
        public double P7_AccelerationProbability { get; set; }

        /// <summary>
        /// High speed deceleration probability.
        /// </summary>
        public double P8_HighSpeedDecProbability { get; set; }

        /// <summary>
        /// Deceleration rate when leading vehicle accelerates.
        /// </summary>
        public double P9_DecRateWhenLeadingAcc { get; set; }

        /// <summary>
        /// Deceleration rate when leading vehicle decelerates.
        /// </summary>
        public double P10_DecRateWhenLeadingDec { get; set; }
    }
}
